----------------
title : C++ 레퍼런스 - cin, wcin 객체
cat_title : cin, wcin
ref_title : cin, wcin, std::cin, std::wcin
publish_date : 2019-04-25
path : /C++ Reference/iostream
--------------

##@ cpp-ref-start

#@ cin, wcin

`<iostream>` 에 정의됨

```cpp-formatted
extern std::istream cin;
extern std::wistream wcin;
```

`std::cin` 과 `std::wcin` 은 전역 객체로, 표준 C 의 입력 스트림인 `stdin` 과 연관된 스트림 객체에서 입력을 받습니다.

`sync_with_stdio(false)` 를 호출하지 않는 이상, 여러 쓰레드에서 동시에 입력 받을 수 있습니다.

`std::cin` 이 생성된 후에, `std::cin.tie()` 를 호출하면 `&std::cout` 을 리턴합니다. (마찬가지로 `std::wcin.tie()` 를 호출하면 `&std::wcout` 을 리턴합니다.)

이 말은 즉슨, `std::cin` 을 통해서 입력을 수행하게 된다면, `std::cout.flush()` 를 즉시 호출해서 출력을 위해 대기하고 있던 문자들을 출력하게 됩니다.

덧붙에 `static` 객체의 생성자에서 `cin` 을 사용하기 위해서는 해당 객체 위에 `iostream` 헤더파일을 포함하면 됩니다. 이 경우 `iostream` 헤더 파일 내에서 `cin` 이 먼저 준비가 되므로, 안전한 스트림 연산을 수행할 수 있습니다. (아래 예시 참고)

참고로 C++ 의 창시자인 Bjarne Stroustrup 의 말에 따르면 `cin` 이란 단어의 뜻은 **문자 입력(character input)** 의 앞글자를 딴 줄인말 이라고 합니다.

### 실행 예제

```cpp-formatted
#include <iostream>
#include <string>
int main() {
  std::cout << "문자열 입력 : ";

  std::string s;
  std::cin >> s;

  std::cout << "받은 문자열 : " << s << std::endl;

  std::cout << "정수 입력 : ";
  int i;
  std::cin >> i;

  std::cout << "받은 정수 : " << i;
  return 0;
}
```

```exec
문자열 입력 : abcdef
받은 문자열 : abcdef
정수 입력 : 123
받은 정수 : 123
```

```cpp-formatted
#include <iostream>
struct Foo {
  int n;
  Foo() {
    std::cout << "Enter n: ";  // flush 필요 없음

    // 이 시점에서 이미 cin 은 사용 준비가 끝남.
    std::cin >> n;
  }
};
Foo f;  // static object
int main() { std::cout << "f.n is " << f.n << '\n'; }
```

```exec
Enter n: 10
f.n is 10
```

### 참고 자료

* `cout`, `wcout` : 표준 C 출력 스트림인 `stdout` 에 출력한다.